﻿//////////////////////////////////////////////
// DdsPixelFlag.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::dds
{
	enum class DDS_PIXEL_FLAG : unsigned int
	{
		DDS_PIXEL_FLAG_UNKNOWN = 0,
		DDPF_ALPHAPIXELS = 0x1,
		DDPF_ALPHA = 0x2,
		DDPF_FOURCC = 0x4,
		DDPF_RGB = 0x40,
		DDPF_YUV = 0x200,
		DDPF_LUMINANCE = 0x200000
	} ;

	inline DDS_PIXEL_FLAG operator& (DDS_PIXEL_FLAG a, DDS_PIXEL_FLAG b)
	{
		return (DDS_PIXEL_FLAG)((unsigned int)a & (unsigned int)b) ;
	}

	inline DDS_PIXEL_FLAG operator| (DDS_PIXEL_FLAG a, DDS_PIXEL_FLAG b)
	{
		return (DDS_PIXEL_FLAG)((unsigned int)a | (unsigned int)b) ;
	}
}